#!/bin/bash
DIR=$(readlink -f $0 | xargs dirname)
if ! [ -f ${DIR}/datastax_cassandra_config_defines.sh ] || ! [ -x ${DIR}/datastax_cassandra_config_defines.sh ]
then
	echo "missing path configuration file for DataStax Cassandra"
	exit 0
fi
source ${DIR}/datastax_cassandra_config_defines.sh

if [ $# -ne 1 ]
then
	echo "run: \`$0 --help\` for more help"
	exit 0
fi
if [ $1 == "--help" ]
then
	echo "--help"
	echo "    print this help message"
	echo "--cppflags"
	echo "    get cpp compilation flags"
	echo "--includedir"
	echo "    get include path"
	echo "--libdir"
	echo "    get lib path"
	echo "--version"
	echo "    get version"
	exit 0
fi
if [ $1 == "--cppflags" ]
then
	exit 0
fi
if [ $1 == "--includedir" ]
then
	echo "${DSC_PATH}/include/"
	exit 0
fi
if [ $1 == "--libdir" ]
then
	echo "${DSC_PATH}/build/"
	exit 0
fi
if [ $1 == "--version" ]
then
	MAJOR=`grep VERSION_MAJOR ${DSC_PATH}/include/cassandra.h | cut -d " " -f 3`
	MINOR=`grep VERSION_MINOR ${DSC_PATH}/include/cassandra.h | cut -d " " -f 3`
	PATCH=`grep VERSION_PATCH ${DSC_PATH}/include/cassandra.h | cut -d " " -f 3`
	echo "${MAJOR}.${MINOR}.${PATCH}"
	exit 0
fi
echo "wrong parameter"
echo "run: \`$0 --help\` for more help"
